<?php
// Load environment variables from .env file
function loadEnv($path) {
    if (!file_exists($path)) {
        return;
    }
    
    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) {
            continue;
        }
        
        if (strpos($line, '=') === false) continue;
        list($name, $value) = explode('=', $line, 2);
        $name = trim($name);
        $value = trim($value);
        
        if (!array_key_exists($name, $_SERVER) && !array_key_exists($name, $_ENV)) {
            putenv(sprintf('%s=%s', $name, $value));
            $_ENV[$name] = $value;
            $_SERVER[$name] = $value;
        }
    }
}

// Load .env file
loadEnv(__DIR__ . '/../.env');

// Database configuration
define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
define('DB_USER', getenv('DB_USER') ?: 'ceiscy_4102009823_dbuser');
define('DB_PASS', getenv('DB_PASSWORD') ?: 'fFAfaf@Y2j7(');
define('DB_NAME', getenv('DB_NAME') ?: 'ceiscy_4102009823_db');

// JWT Secret
define('JWT_SECRET', getenv('JWT_SECRET') ?: 'chilla_perfumery_jwt_secret_2024_production_secure_key');

// Upload configuration
define('UPLOAD_PATH', getenv('UPLOAD_PATH') ?: 'uploads');
define('MAX_FILE_SIZE', getenv('MAX_FILE_SIZE') ?: 5242880); // 5MB

// Website URL
define('WEBSITE_URL', getenv('WEBSITE_URL') ?: 'https://4102009823.ceiscy.com');

// Allowed origins for CORS
$allowedOrigins = getenv('ALLOWED_ORIGINS') ? explode(',', getenv('ALLOWED_ORIGINS')) : ['https://4102009823.ceiscy.com'];
define('ALLOWED_ORIGINS', $allowedOrigins);
?>