<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';

handleCORS();

$method = $_SERVER['REQUEST_METHOD'];
$db = Database::getInstance();

switch ($method) {
    case 'GET':
        $user = requireAuth();
        
        if (isset($_GET['id'])) {
            $supplier = $db->fetchOne('SELECT * FROM suppliers WHERE id = ?', [$_GET['id']]);
            if (!$supplier) {
                errorResponse('Supplier not found', 404);
            }
            successResponse(['supplier' => $supplier]);
        } else {
            $suppliers = $db->fetchAll('SELECT * FROM suppliers WHERE is_active = TRUE ORDER BY name');
            successResponse(['suppliers' => $suppliers]);
        }
        break;
        
    case 'POST':
        $user = requireAuth();
        requireRole(['admin'], $user);
        
        $data = getRequestBody();
        validateRequired($data, ['name']);
        
        $result = $db->execute(
            'INSERT INTO suppliers (name, phone, email, address, contact_person) VALUES (?, ?, ?, ?, ?)',
            [
                $data['name'],
                $data['phone'] ?? null,
                $data['email'] ?? null,
                $data['address'] ?? null,
                $data['contact_person'] ?? null
            ]
        );
        
        successResponse(['supplierId' => $result['lastInsertId']], 'Supplier created successfully', 201);
        break;
        
    case 'PUT':
        $user = requireAuth();
        requireRole(['admin'], $user);
        
        if (!isset($_GET['id'])) {
            errorResponse('Supplier ID required', 400);
        }
        
        $data = getRequestBody();
        
        $updateFields = [];
        $updateValues = [];
        
        $allowedFields = ['name', 'phone', 'email', 'address', 'contact_person', 'is_active'];
        
        foreach ($allowedFields as $field) {
            if (array_key_exists($field, $data)) {
                $updateFields[] = "$field = ?";
                $updateValues[] = $data[$field];
            }
        }
        
        if (empty($updateFields)) {
            errorResponse('No fields to update', 400);
        }
        
        $updateValues[] = $_GET['id'];
        
        $db->execute(
            'UPDATE suppliers SET ' . implode(', ', $updateFields) . ' WHERE id = ?',
            $updateValues
        );
        
        successResponse([], 'Supplier updated successfully');
        break;
        
    case 'DELETE':
        $user = requireAuth();
        requireRole(['admin'], $user);
        
        if (!isset($_GET['id'])) {
            errorResponse('Supplier ID required', 400);
        }
        
        $db->execute('UPDATE suppliers SET is_active = FALSE WHERE id = ?', [$_GET['id']]);
        
        successResponse([], 'Supplier deleted successfully');
        break;
}

errorResponse('Invalid request', 400);
?>