<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';

handleCORS();

$method = $_SERVER['REQUEST_METHOD'];
$db = Database::getInstance();

switch ($method) {
    case 'GET':
        $user = requireAuth();
        
        if (isset($_GET['id'])) {
            $category = $db->fetchOne('SELECT * FROM categories WHERE id = ?', [$_GET['id']]);
            if (!$category) {
                errorResponse('Category not found', 404);
            }
            successResponse(['category' => $category]);
        } else {
            $categories = $db->fetchAll('SELECT * FROM categories ORDER BY name');
            successResponse(['categories' => $categories]);
        }
        break;
        
    case 'POST':
        $user = requireAuth();
        requireRole(['admin'], $user);
        
        $data = getRequestBody();
        validateRequired($data, ['name']);
        
        $existing = $db->fetchOne('SELECT id FROM categories WHERE name = ?', [$data['name']]);
        if ($existing) {
            errorResponse('Category already exists', 400);
        }
        
        $result = $db->execute(
            'INSERT INTO categories (name, description) VALUES (?, ?)',
            [$data['name'], $data['description'] ?? null]
        );
        
        successResponse(['categoryId' => $result['lastInsertId']], 'Category created successfully', 201);
        break;
        
    case 'PUT':
        $user = requireAuth();
        requireRole(['admin'], $user);
        
        if (!isset($_GET['id'])) {
            errorResponse('Category ID required', 400);
        }
        
        $data = getRequestBody();
        
        $updateFields = [];
        $updateValues = [];
        
        if (isset($data['name'])) {
            $updateFields[] = 'name = ?';
            $updateValues[] = $data['name'];
        }
        
        if (isset($data['description'])) {
            $updateFields[] = 'description = ?';
            $updateValues[] = $data['description'];
        }
        
        if (empty($updateFields)) {
            errorResponse('No fields to update', 400);
        }
        
        $updateValues[] = $_GET['id'];
        
        $db->execute(
            'UPDATE categories SET ' . implode(', ', $updateFields) . ' WHERE id = ?',
            $updateValues
        );
        
        successResponse([], 'Category updated successfully');
        break;
        
    case 'DELETE':
        $user = requireAuth();
        requireRole(['admin'], $user);
        
        if (!isset($_GET['id'])) {
            errorResponse('Category ID required', 400);
        }
        
        // Check if category is used by products
        $products = $db->fetchOne('SELECT COUNT(*) as count FROM products WHERE category_id = ?', [$_GET['id']]);
        if ($products['count'] > 0) {
            errorResponse('Cannot delete category that is used by products', 400);
        }
        
        $db->execute('DELETE FROM categories WHERE id = ?', [$_GET['id']]);
        
        successResponse([], 'Category deleted successfully');
        break;
}

errorResponse('Invalid request', 400);
?>