<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';

handleCORS();

$method = $_SERVER['REQUEST_METHOD'];
$db = Database::getInstance();

switch ($method) {
    case 'GET':
        $user = requireAuth();
        
        if (isset($_GET['generate'])) {
            // Generate a new barcode
            $barcode = 'CHI' . str_pad(mt_rand(1, 999999999), 9, '0', STR_PAD_LEFT);
            
            // Check if barcode already exists
            $existing = $db->fetchOne('SELECT id FROM products WHERE barcode = ?', [$barcode]);
            while ($existing) {
                $barcode = 'CHI' . str_pad(mt_rand(1, 999999999), 9, '0', STR_PAD_LEFT);
                $existing = $db->fetchOne('SELECT id FROM products WHERE barcode = ?', [$barcode]);
            }
            
            successResponse(['barcode' => $barcode]);
            
        } elseif (isset($_GET['image']) && $_GET['image']) {
            // Generate barcode image (simple text response for now)
            header('Content-Type: text/plain');
            echo $_GET['image'];
            exit;
            
        } elseif (isset($_GET['label']) && $_GET['label']) {
            // Generate barcode label (simple text response for now)
            header('Content-Type: text/plain');
            echo "Label: " . $_GET['label'];
            exit;
        }
        break;
}

errorResponse('Invalid request', 400);
?>